using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for PatientSpecimenSelectorSimple.
	/// </summary>
	public class PatientSpecimenSelector : GUI.controls.BaseControl
	{

		#region Variables

		private BOL.Specimen _specimen;
		private DataTable _dtSpecimenSearchDetails;
		private Guid _patientSpecimenGUID;
		private bool _acceptableOnlySpecimen = true;
		private BOL.Patient _patient;

		private Regex _lastfiveEx =  Common.RegularExpressions.PatientInitialAndLastFourSSN();
		private Regex _ssnEx = Common.RegularExpressions.PatientSsn();
		private Regex _nameEx =  Common.RegularExpressions.PatientName();

		#endregion


		#region Events

		/// <summary>
		/// ItemSelected EventHandler
		/// </summary>
		public event EventHandler ItemSelected;

		/// <summary>
		/// ItemDeselected EventHandler
		/// </summary>
		public event EventHandler ItemDeselected;
		
		#endregion



		#region Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpSearchCriteria;
		private System.Windows.Forms.PictureBox pictureBox2;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSearchNameSSN;
		private System.Windows.Forms.Label lblSearchOrderNumber;
		private System.Windows.Forms.Label lblSearchNameSSN;
		private System.Windows.Forms.GroupBox grpSearchResults;
		private System.Windows.Forms.ListView lvSearchResults;
		private System.Windows.Forms.ColumnHeader colVBECSSpecimen;
		private System.Windows.Forms.ColumnHeader colPatientName;
		private System.Windows.Forms.ColumnHeader colSSN;
		private System.Windows.Forms.GroupBox grpSelectedSpecimen;
		private System.Windows.Forms.TextBox txtVisualInspection;
		private System.Windows.Forms.Label lblVisualInspection;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblPatientName;
		private System.Windows.Forms.TextBox txtSSN;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.TextBox txtABORh;
		private System.Windows.Forms.TextBox txtSex;
		private System.Windows.Forms.Label lblDOB;
		private System.Windows.Forms.TextBox txtDOB;
		private System.Windows.Forms.Label lblSSN;
		private System.Windows.Forms.Label lblSex;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.TextBox txtCollectionDate;
		private System.Windows.Forms.TextBox txtSpecimenNumber;
		private System.Windows.Forms.Label lblSpecimenNumber;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.Label lblPhlebotomist;
		private System.Windows.Forms.TextBox txtPhlebotomist;
		private System.Windows.Forms.Label lblCollectionDate;
		private System.Windows.Forms.ColumnHeader colExpires;
		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.TextBox txtReceivedDate;
		private System.Windows.Forms.Label lblReceivedDate;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSearchOrderNumber;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar patientInfoToolbar1;
		private System.Windows.Forms.PictureBox picJustified;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblExpiresAfter;
		private System.Windows.Forms.DateTimePicker dtpExpiresAfter;
		private System.Windows.Forms.CheckBox cbShowUnacceptable;
		private System.Windows.Forms.PictureBox pictureBox3;
		private System.ComponentModel.IContainer components;

		#endregion


		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public PatientSpecimenSelector()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			SetComponentProperties();
			_patient = null;
			this.txtSearchNameSSN.Focus();

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientSpecimenSelector));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpSearchCriteria = new System.Windows.Forms.GroupBox();
			this.pictureBox3 = new System.Windows.Forms.PictureBox();
			this.dtpExpiresAfter = new System.Windows.Forms.DateTimePicker();
			this.lblExpiresAfter = new System.Windows.Forms.Label();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtSearchOrderNumber = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.txtSearchNameSSN = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.lblSearchOrderNumber = new System.Windows.Forms.Label();
			this.lblSearchNameSSN = new System.Windows.Forms.Label();
			this.grpSearchResults = new System.Windows.Forms.GroupBox();
			this.cbShowUnacceptable = new System.Windows.Forms.CheckBox();
			this.lvSearchResults = new System.Windows.Forms.ListView();
			this.colVBECSSpecimen = new System.Windows.Forms.ColumnHeader();
			this.colExpires = new System.Windows.Forms.ColumnHeader();
			this.colPatientName = new System.Windows.Forms.ColumnHeader();
			this.colSSN = new System.Windows.Forms.ColumnHeader();
			this.grpSelectedSpecimen = new System.Windows.Forms.GroupBox();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblComment = new System.Windows.Forms.Label();
			this.txtReceivedDate = new System.Windows.Forms.TextBox();
			this.lblReceivedDate = new System.Windows.Forms.Label();
			this.txtVisualInspection = new System.Windows.Forms.TextBox();
			this.lblVisualInspection = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.txtCollectionDate = new System.Windows.Forms.TextBox();
			this.txtSpecimenNumber = new System.Windows.Forms.TextBox();
			this.lblSpecimenNumber = new System.Windows.Forms.Label();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtPhlebotomist = new System.Windows.Forms.TextBox();
			this.lblCollectionDate = new System.Windows.Forms.Label();
			this.lblPhlebotomist = new System.Windows.Forms.Label();
			this.lblPatientName = new System.Windows.Forms.Label();
			this.txtSSN = new System.Windows.Forms.TextBox();
			this.lblABORh = new System.Windows.Forms.Label();
			this.txtABORh = new System.Windows.Forms.TextBox();
			this.txtSex = new System.Windows.Forms.TextBox();
			this.lblDOB = new System.Windows.Forms.Label();
			this.txtDOB = new System.Windows.Forms.TextBox();
			this.lblSSN = new System.Windows.Forms.Label();
			this.lblSex = new System.Windows.Forms.Label();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.picJustified = new System.Windows.Forms.PictureBox();
			this.patientInfoToolbar1 = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.grpImage.SuspendLayout();
			this.grpSearchCriteria.SuspendLayout();
			this.grpSearchResults.SuspendLayout();
			this.grpSelectedSpecimen.SuspendLayout();
			this.grpPatient.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 376);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpSearchCriteria
			// 
			this.grpSearchCriteria.AccessibleDescription = "Specimen Search Criteria";
			this.grpSearchCriteria.AccessibleName = "Specimen Search Criteria";
			this.grpSearchCriteria.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchCriteria.Controls.Add(this.pictureBox3);
			this.grpSearchCriteria.Controls.Add(this.dtpExpiresAfter);
			this.grpSearchCriteria.Controls.Add(this.lblExpiresAfter);
			this.grpSearchCriteria.Controls.Add(this.btnSearch);
			this.grpSearchCriteria.Controls.Add(this.txtSearchOrderNumber);
			this.grpSearchCriteria.Controls.Add(this.pictureBox2);
			this.grpSearchCriteria.Controls.Add(this.txtSearchNameSSN);
			this.grpSearchCriteria.Controls.Add(this.lblSearchOrderNumber);
			this.grpSearchCriteria.Controls.Add(this.lblSearchNameSSN);
			this.grpSearchCriteria.Location = new System.Drawing.Point(56, 0);
			this.grpSearchCriteria.Name = "grpSearchCriteria";
			this.grpSearchCriteria.Size = new System.Drawing.Size(320, 96);
			this.grpSearchCriteria.TabIndex = 0;
			this.grpSearchCriteria.TabStop = false;
			this.grpSearchCriteria.Text = "Specimen Search Criteria*";
			// 
			// pictureBox3
			// 
			this.pictureBox3.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox3.Image")));
			this.pictureBox3.Location = new System.Drawing.Point(4, 24);
			this.pictureBox3.Name = "pictureBox3";
			this.pictureBox3.Size = new System.Drawing.Size(20, 20);
			this.pictureBox3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox3.TabIndex = 118;
			this.pictureBox3.TabStop = false;
			// 
			// dtpExpiresAfter
			// 
			this.dtpExpiresAfter.AccessibleDescription = "Expires After";
			this.dtpExpiresAfter.AccessibleName = "Expires After";
			this.dtpExpiresAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpiresAfter.CustomFormat = "MM/dd/yyyy";
			this.dtpExpiresAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpiresAfter.Location = new System.Drawing.Point(96, 68);
			this.dtpExpiresAfter.Name = "dtpExpiresAfter";
			this.dtpExpiresAfter.Size = new System.Drawing.Size(140, 20);
			this.dtpExpiresAfter.TabIndex = 3;
			// 
			// lblExpiresAfter
			// 
			this.lblExpiresAfter.Location = new System.Drawing.Point(24, 68);
			this.lblExpiresAfter.Name = "lblExpiresAfter";
			this.lblExpiresAfter.Size = new System.Drawing.Size(80, 20);
			this.lblExpiresAfter.TabIndex = 4;
			this.lblExpiresAfter.Text = "Expires After";
			this.lblExpiresAfter.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(240, 68);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 4;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			this.btnSearch.MouseHover += new System.EventHandler(this.btnSearch_MouseHover);
			// 
			// txtSearchOrderNumber
			// 
			this.txtSearchOrderNumber.AccessibleDescription = "Specimen U I D ";
			this.txtSearchOrderNumber.AccessibleName = "Specimen U I D";
			this.txtSearchOrderNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchOrderNumber.Barcode = false;
			this.txtSearchOrderNumber.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtSearchOrderNumber.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtSearchOrderNumber.Location = new System.Drawing.Point(96, 44);
			this.txtSearchOrderNumber.MaxLength = 15;
			this.txtSearchOrderNumber.Name = "txtSearchOrderNumber";
			this.txtSearchOrderNumber.Size = new System.Drawing.Size(216, 20);
			this.txtSearchOrderNumber.TabIndex = 2;
			this.txtSearchOrderNumber.Text = "";
			this.txtSearchOrderNumber.TextChanged += new System.EventHandler(this.SearchCriteriaChanged);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 48);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 113;
			this.pictureBox2.TabStop = false;
			// 
			// txtSearchNameSSN
			// 
			this.txtSearchNameSSN.AccessibleDescription = "Patient";
			this.txtSearchNameSSN.AccessibleName = "Patient";
			this.txtSearchNameSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchNameSSN.Barcode = false;
			this.txtSearchNameSSN.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtSearchNameSSN.Location = new System.Drawing.Point(96, 20);
			this.txtSearchNameSSN.MaxLength = 30;
			this.txtSearchNameSSN.Name = "txtSearchNameSSN";
			this.txtSearchNameSSN.Size = new System.Drawing.Size(216, 20);
			this.txtSearchNameSSN.TabIndex = 1;
			this.txtSearchNameSSN.Text = "";
			this.txtSearchNameSSN.Leave += new System.EventHandler(this.txtSearchNameSSN_Leave);
			this.txtSearchNameSSN.TextChanged += new System.EventHandler(this.SearchCriteriaChanged);
			// 
			// lblSearchOrderNumber
			// 
			this.lblSearchOrderNumber.Location = new System.Drawing.Point(24, 44);
			this.lblSearchOrderNumber.Name = "lblSearchOrderNumber";
			this.lblSearchOrderNumber.Size = new System.Drawing.Size(80, 20);
			this.lblSearchOrderNumber.TabIndex = 2;
			this.lblSearchOrderNumber.Text = "Specimen UID";
			this.lblSearchOrderNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSearchNameSSN
			// 
			this.lblSearchNameSSN.Location = new System.Drawing.Point(24, 20);
			this.lblSearchNameSSN.Name = "lblSearchNameSSN";
			this.lblSearchNameSSN.Size = new System.Drawing.Size(76, 20);
			this.lblSearchNameSSN.TabIndex = 0;
			this.lblSearchNameSSN.Text = "Patient ";
			this.lblSearchNameSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSearchResults
			// 
			this.grpSearchResults.AccessibleDescription = "Specimen Search Results";
			this.grpSearchResults.AccessibleName = "Specimen Search Results";
			this.grpSearchResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchResults.Controls.Add(this.cbShowUnacceptable);
			this.grpSearchResults.Controls.Add(this.lvSearchResults);
			this.grpSearchResults.Location = new System.Drawing.Point(56, 96);
			this.grpSearchResults.Name = "grpSearchResults";
			this.grpSearchResults.Size = new System.Drawing.Size(320, 280);
			this.grpSearchResults.TabIndex = 5;
			this.grpSearchResults.TabStop = false;
			this.grpSearchResults.Text = "Specimen Search Results";
			// 
			// cbShowUnacceptable
			// 
			this.cbShowUnacceptable.AccessibleDescription = "Include Unacceptable Specimens";
			this.cbShowUnacceptable.AccessibleName = "Include Unacceptable Specimens";
			this.cbShowUnacceptable.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbShowUnacceptable.Location = new System.Drawing.Point(4, 260);
			this.cbShowUnacceptable.Name = "cbShowUnacceptable";
			this.cbShowUnacceptable.Size = new System.Drawing.Size(308, 16);
			this.cbShowUnacceptable.TabIndex = 7;
			this.cbShowUnacceptable.Text = "&Include Unacceptable Specimens";
			this.cbShowUnacceptable.CheckedChanged += new System.EventHandler(this.cbShowUnacceptable_CheckedChanged);
			// 
			// lvSearchResults
			// 
			this.lvSearchResults.AccessibleDescription = "Specimen Search Results";
			this.lvSearchResults.AccessibleName = "Specimen Search Results";
			this.lvSearchResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSearchResults.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.colVBECSSpecimen,
																							  this.colExpires,
																							  this.colPatientName,
																							  this.colSSN});
			this.lvSearchResults.FullRowSelect = true;
			this.lvSearchResults.HideSelection = false;
			this.lvSearchResults.Location = new System.Drawing.Point(5, 16);
			this.lvSearchResults.MultiSelect = false;
			this.lvSearchResults.Name = "lvSearchResults";
			this.lvSearchResults.Size = new System.Drawing.Size(304, 244);
			this.lvSearchResults.TabIndex = 6;
			this.lvSearchResults.View = System.Windows.Forms.View.Details;
			this.lvSearchResults.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSearchResults_ColumnClick);
			this.lvSearchResults.SelectedIndexChanged += new System.EventHandler(this.lvSearchResults_SelectedIndexChanged);
			// 
			// colVBECSSpecimen
			// 
			this.colVBECSSpecimen.Text = "Specimen UID";
			this.colVBECSSpecimen.Width = 80;
			// 
			// colExpires
			// 
			this.colExpires.Text = "Expires";
			this.colExpires.Width = 100;
			// 
			// colPatientName
			// 
			this.colPatientName.Text = "Patient Name";
			this.colPatientName.Width = 100;
			// 
			// colSSN
			// 
			this.colSSN.Text = "Patient ID";
			this.colSSN.Width = 70;
			// 
			// grpSelectedSpecimen
			// 
			this.grpSelectedSpecimen.AccessibleDescription = "Selected Patient Specimen ";
			this.grpSelectedSpecimen.AccessibleName = "Selected Patient Specimen ";
			this.grpSelectedSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelectedSpecimen.Controls.Add(this.txtComment);
			this.grpSelectedSpecimen.Controls.Add(this.lblComment);
			this.grpSelectedSpecimen.Controls.Add(this.txtReceivedDate);
			this.grpSelectedSpecimen.Controls.Add(this.lblReceivedDate);
			this.grpSelectedSpecimen.Controls.Add(this.txtVisualInspection);
			this.grpSelectedSpecimen.Controls.Add(this.lblVisualInspection);
			this.grpSelectedSpecimen.Controls.Add(this.txtExpirationDate);
			this.grpSelectedSpecimen.Controls.Add(this.txtCollectionDate);
			this.grpSelectedSpecimen.Controls.Add(this.txtSpecimenNumber);
			this.grpSelectedSpecimen.Controls.Add(this.lblSpecimenNumber);
			this.grpSelectedSpecimen.Controls.Add(this.lblExpirationDate);
			this.grpSelectedSpecimen.Controls.Add(this.txtPhlebotomist);
			this.grpSelectedSpecimen.Controls.Add(this.lblCollectionDate);
			this.grpSelectedSpecimen.Controls.Add(this.lblPhlebotomist);
			this.grpSelectedSpecimen.Location = new System.Drawing.Point(380, 0);
			this.grpSelectedSpecimen.Name = "grpSelectedSpecimen";
			this.grpSelectedSpecimen.Size = new System.Drawing.Size(308, 192);
			this.grpSelectedSpecimen.TabIndex = 8;
			this.grpSelectedSpecimen.TabStop = false;
			this.grpSelectedSpecimen.Text = "Selected Patient Specimen";
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "Comment";
			this.txtComment.AccessibleName = "Comment";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(100, 164);
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.ReadOnly = true;
			this.txtComment.Size = new System.Drawing.Size(196, 20);
			this.txtComment.TabIndex = 15;
			this.txtComment.Text = "";
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 164);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(96, 20);
			this.lblComment.TabIndex = 12;
			this.lblComment.Text = "Comment";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReceivedDate
			// 
			this.txtReceivedDate.AccessibleDescription = "Received Date";
			this.txtReceivedDate.AccessibleName = "Received Date";
			this.txtReceivedDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReceivedDate.Location = new System.Drawing.Point(100, 68);
			this.txtReceivedDate.Name = "txtReceivedDate";
			this.txtReceivedDate.ReadOnly = true;
			this.txtReceivedDate.Size = new System.Drawing.Size(196, 20);
			this.txtReceivedDate.TabIndex = 11;
			this.txtReceivedDate.Text = "";
			// 
			// lblReceivedDate
			// 
			this.lblReceivedDate.Location = new System.Drawing.Point(8, 68);
			this.lblReceivedDate.Name = "lblReceivedDate";
			this.lblReceivedDate.Size = new System.Drawing.Size(96, 20);
			this.lblReceivedDate.TabIndex = 4;
			this.lblReceivedDate.Text = "Received Date";
			this.lblReceivedDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtVisualInspection
			// 
			this.txtVisualInspection.AccessibleDescription = "Visual Inspection";
			this.txtVisualInspection.AccessibleName = "Visual Inspection";
			this.txtVisualInspection.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtVisualInspection.Location = new System.Drawing.Point(100, 140);
			this.txtVisualInspection.Name = "txtVisualInspection";
			this.txtVisualInspection.ReadOnly = true;
			this.txtVisualInspection.Size = new System.Drawing.Size(196, 20);
			this.txtVisualInspection.TabIndex = 14;
			this.txtVisualInspection.Text = "";
			// 
			// lblVisualInspection
			// 
			this.lblVisualInspection.Location = new System.Drawing.Point(8, 140);
			this.lblVisualInspection.Name = "lblVisualInspection";
			this.lblVisualInspection.Size = new System.Drawing.Size(96, 20);
			this.lblVisualInspection.TabIndex = 10;
			this.lblVisualInspection.Text = "Visual Inspection";
			this.lblVisualInspection.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtExpirationDate.AccessibleName = "Expiration Date";
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(100, 92);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(196, 20);
			this.txtExpirationDate.TabIndex = 12;
			this.txtExpirationDate.Text = "";
			// 
			// txtCollectionDate
			// 
			this.txtCollectionDate.AccessibleDescription = "Collection Date";
			this.txtCollectionDate.AccessibleName = "Collection Date";
			this.txtCollectionDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCollectionDate.Location = new System.Drawing.Point(100, 44);
			this.txtCollectionDate.Name = "txtCollectionDate";
			this.txtCollectionDate.ReadOnly = true;
			this.txtCollectionDate.Size = new System.Drawing.Size(196, 20);
			this.txtCollectionDate.TabIndex = 10;
			this.txtCollectionDate.Text = "";
			// 
			// txtSpecimenNumber
			// 
			this.txtSpecimenNumber.AccessibleDescription = "Specimen U I D";
			this.txtSpecimenNumber.AccessibleName = "Specimen U I D ";
			this.txtSpecimenNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenNumber.Location = new System.Drawing.Point(100, 20);
			this.txtSpecimenNumber.Name = "txtSpecimenNumber";
			this.txtSpecimenNumber.ReadOnly = true;
			this.txtSpecimenNumber.Size = new System.Drawing.Size(196, 20);
			this.txtSpecimenNumber.TabIndex = 9;
			this.txtSpecimenNumber.Text = "";
			// 
			// lblSpecimenNumber
			// 
			this.lblSpecimenNumber.Location = new System.Drawing.Point(8, 20);
			this.lblSpecimenNumber.Name = "lblSpecimenNumber";
			this.lblSpecimenNumber.Size = new System.Drawing.Size(120, 20);
			this.lblSpecimenNumber.TabIndex = 0;
			this.lblSpecimenNumber.Text = "Specimen UID";
			this.lblSpecimenNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 92);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(96, 20);
			this.lblExpirationDate.TabIndex = 6;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPhlebotomist
			// 
			this.txtPhlebotomist.AccessibleDescription = "Phlebotomist";
			this.txtPhlebotomist.AccessibleName = "Phlebotomist";
			this.txtPhlebotomist.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPhlebotomist.Location = new System.Drawing.Point(100, 116);
			this.txtPhlebotomist.Name = "txtPhlebotomist";
			this.txtPhlebotomist.ReadOnly = true;
			this.txtPhlebotomist.Size = new System.Drawing.Size(196, 20);
			this.txtPhlebotomist.TabIndex = 13;
			this.txtPhlebotomist.Text = "";
			// 
			// lblCollectionDate
			// 
			this.lblCollectionDate.Location = new System.Drawing.Point(8, 44);
			this.lblCollectionDate.Name = "lblCollectionDate";
			this.lblCollectionDate.Size = new System.Drawing.Size(96, 20);
			this.lblCollectionDate.TabIndex = 2;
			this.lblCollectionDate.Text = "Collection Date";
			this.lblCollectionDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPhlebotomist
			// 
			this.lblPhlebotomist.Location = new System.Drawing.Point(8, 116);
			this.lblPhlebotomist.Name = "lblPhlebotomist";
			this.lblPhlebotomist.Size = new System.Drawing.Size(96, 20);
			this.lblPhlebotomist.TabIndex = 8;
			this.lblPhlebotomist.Text = "Phlebotomist";
			this.lblPhlebotomist.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPatientName
			// 
			this.lblPatientName.Location = new System.Drawing.Point(8, 16);
			this.lblPatientName.Name = "lblPatientName";
			this.lblPatientName.Size = new System.Drawing.Size(84, 20);
			this.lblPatientName.TabIndex = 0;
			this.lblPatientName.Text = "Patient Name";
			this.lblPatientName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSSN
			// 
			this.txtSSN.AccessibleDescription = "Patient I D";
			this.txtSSN.AccessibleName = "Patient I D";
			this.txtSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSSN.Location = new System.Drawing.Point(100, 56);
			this.txtSSN.Name = "txtSSN";
			this.txtSSN.ReadOnly = true;
			this.txtSSN.Size = new System.Drawing.Size(200, 20);
			this.txtSSN.TabIndex = 18;
			this.txtSSN.Text = "";
			// 
			// lblABORh
			// 
			this.lblABORh.Location = new System.Drawing.Point(8, 128);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(68, 20);
			this.lblABORh.TabIndex = 8;
			this.lblABORh.Text = "ABO/Rh";
			this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABORh
			// 
			this.txtABORh.AccessibleDescription = "A B O R h";
			this.txtABORh.AccessibleName = "A B O R h";
			this.txtABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtABORh.Location = new System.Drawing.Point(100, 128);
			this.txtABORh.Name = "txtABORh";
			this.txtABORh.ReadOnly = true;
			this.txtABORh.Size = new System.Drawing.Size(200, 20);
			this.txtABORh.TabIndex = 21;
			this.txtABORh.Text = "";
			// 
			// txtSex
			// 
			this.txtSex.AccessibleDescription = "Patient Sex";
			this.txtSex.AccessibleName = "Patient Sex";
			this.txtSex.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSex.Location = new System.Drawing.Point(100, 80);
			this.txtSex.Name = "txtSex";
			this.txtSex.ReadOnly = true;
			this.txtSex.Size = new System.Drawing.Size(200, 20);
			this.txtSex.TabIndex = 19;
			this.txtSex.Text = "";
			// 
			// lblDOB
			// 
			this.lblDOB.Location = new System.Drawing.Point(8, 104);
			this.lblDOB.Name = "lblDOB";
			this.lblDOB.Size = new System.Drawing.Size(72, 20);
			this.lblDOB.TabIndex = 6;
			this.lblDOB.Text = "Date of Birth";
			this.lblDOB.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDOB
			// 
			this.txtDOB.AccessibleDescription = "Date of Birth";
			this.txtDOB.AccessibleName = "Date of Birth";
			this.txtDOB.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDOB.Location = new System.Drawing.Point(100, 104);
			this.txtDOB.Name = "txtDOB";
			this.txtDOB.ReadOnly = true;
			this.txtDOB.Size = new System.Drawing.Size(200, 20);
			this.txtDOB.TabIndex = 20;
			this.txtDOB.Text = "";
			// 
			// lblSSN
			// 
			this.lblSSN.Location = new System.Drawing.Point(8, 56);
			this.lblSSN.Name = "lblSSN";
			this.lblSSN.Size = new System.Drawing.Size(84, 20);
			this.lblSSN.TabIndex = 2;
			this.lblSSN.Text = "Patient ID";
			this.lblSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSex
			// 
			this.lblSex.Location = new System.Drawing.Point(8, 80);
			this.lblSex.Name = "lblSex";
			this.lblSex.Size = new System.Drawing.Size(84, 20);
			this.lblSex.TabIndex = 4;
			this.lblSex.Text = "Patient Sex";
			this.lblSex.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPatientName
			// 
			this.txtPatientName.AccessibleDescription = "Patient Name";
			this.txtPatientName.AccessibleName = "Patient Name";
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(100, 16);
			this.txtPatientName.Multiline = true;
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(200, 36);
			this.txtPatientName.TabIndex = 17;
			this.txtPatientName.Text = "";
			// 
			// grpPatient
			// 
			this.grpPatient.AccessibleDescription = "Selected Patient";
			this.grpPatient.AccessibleName = "Selected Patient";
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.picJustified);
			this.grpPatient.Controls.Add(this.patientInfoToolbar1);
			this.grpPatient.Controls.Add(this.txtABORh);
			this.grpPatient.Controls.Add(this.lblABORh);
			this.grpPatient.Controls.Add(this.txtDOB);
			this.grpPatient.Controls.Add(this.lblSSN);
			this.grpPatient.Controls.Add(this.txtSex);
			this.grpPatient.Controls.Add(this.lblDOB);
			this.grpPatient.Controls.Add(this.txtSSN);
			this.grpPatient.Controls.Add(this.lblPatientName);
			this.grpPatient.Controls.Add(this.lblSex);
			this.grpPatient.Controls.Add(this.txtPatientName);
			this.grpPatient.Location = new System.Drawing.Point(380, 192);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(308, 184);
			this.grpPatient.TabIndex = 16;
			this.grpPatient.TabStop = false;
			this.grpPatient.Text = "Selected Patient";
			// 
			// picJustified
			// 
			this.picJustified.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picJustified.Image = ((System.Drawing.Image)(resources.GetObject("picJustified.Image")));
			this.picJustified.Location = new System.Drawing.Point(280, 128);
			this.picJustified.Name = "picJustified";
			this.picJustified.Size = new System.Drawing.Size(16, 16);
			this.picJustified.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picJustified.TabIndex = 74;
			this.picJustified.TabStop = false;
			this.toolTip1.SetToolTip(this.picJustified, "The patient has a history of  justified ABO/Rh change");
			this.picJustified.Visible = false;
			// 
			// patientInfoToolbar1
			// 
			this.patientInfoToolbar1.AccessibleDescription = "Patient Information";
			this.patientInfoToolbar1.AccessibleName = "Patient Information";
			this.patientInfoToolbar1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.patientInfoToolbar1.EnabledBloodAvailButton = false;
			this.patientInfoToolbar1.EnabledMedicationButton = false;
			this.patientInfoToolbar1.EnabledRecentOrdersButton = false;
			this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientInfoToolbar1.EnabledSIAndTRButton = false;
			this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = false;
			this.patientInfoToolbar1.Location = new System.Drawing.Point(148, 152);
			this.patientInfoToolbar1.Name = "patientInfoToolbar1";
			this.patientInfoToolbar1.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientInfoToolbar1.Patient = null;
			this.patientInfoToolbar1.Size = new System.Drawing.Size(154, 20);
			this.patientInfoToolbar1.TabIndex = 22;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// PatientSpecimenSelector
			// 
			this.AccessibleDescription = "Patient Specimen Selector";
			this.AccessibleName = "Patient Specimen Selector";
			this.Controls.Add(this.grpSelectedSpecimen);
			this.Controls.Add(this.grpSearchResults);
			this.Controls.Add(this.grpSearchCriteria);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpPatient);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(178)));
			this.Name = "PatientSpecimenSelector";
			this.Size = new System.Drawing.Size(688, 376);
			this.grpImage.ResumeLayout(false);
			this.grpSearchCriteria.ResumeLayout(false);
			this.grpSearchResults.ResumeLayout(false);
			this.grpSelectedSpecimen.ResumeLayout(false);
			this.grpPatient.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get/Set Specimen
		/// </summary>
		public BOL.Specimen Specimen
		{
			get
			{
				return this._specimen;
			}
			set
			{
				this._specimen = value;
			}
		}

		/// <summary>
		/// Get/Set Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				if (this._patient != null)
				{
					if (_patient.LastName.Length > 0)
					{
						this.txtSearchNameSSN.Text = this._patient.LastName.ToString();
						this.txtSearchNameSSN.ReadOnly = true;
						this.btnSearch.Enabled = true;
					}
				}
			}
		}

		/// <summary>
		/// Set the partial value of Specimen UID to search for
		/// </summary>
		public string SearchSpecimenUid
		{
			set
			{
				this.txtSearchOrderNumber.Text = value;
			}
		}

		/// <summary>
		/// Get the value of PatientSpecimenGuid
		/// </summary>
		public Guid PatientSpecimenGuid
		{
			get
			{
				return _patientSpecimenGUID;
			}
		}

		/// <summary>
		/// Get the value of Patient Specimen UID
		/// </summary>
		public string PatientSpecimenUid
		{
			get
			{
				return this.txtSpecimenNumber.Text;
			}
		}

		/// <summary>
		/// Get and set the value of AcceptableOnlySpecimen
		/// </summary>
		public bool AcceptableOnlySpecimen
		{
			set
			{
				this._acceptableOnlySpecimen = value;
			}
			
			get
			{
				return _acceptableOnlySpecimen;
			}
		}

		#endregion


		#region Methods

		/// <summary>
		/// Clear the data on the form
		/// </summary>
		private void Clear()
		{
			//Clear search items
			this.lvSearchResults.Items.Clear();

			//Specimen
			this.txtSpecimenNumber.Text = string.Empty;
			this.txtExpirationDate.Text = string.Empty;
			this.txtPhlebotomist.Text = string.Empty;
			this.txtCollectionDate.Text = string.Empty;
			this.txtReceivedDate.Text = string.Empty;
			this.txtVisualInspection.Text = string.Empty;
			this.txtComment.Text = string.Empty;

			//Patient
			this.txtPatientName.Text = string.Empty;
			this.txtSSN.Text = string.Empty;
			this.txtSex.Text = string.Empty;
			this.txtDOB.Text = string.Empty;
			this.txtABORh.Text = string.Empty;
			this.picJustified.Visible = false;

			//Fire deselected item event
			this.OnItemDeselected();
		}

		/// <summary>
		/// Populates the list of specimens
		/// </summary>
		private void PopulateForm()
		{
			this.lvSearchResults.Items.Clear();

			foreach ( DataRow drSpecimenSearchDetails in _dtSpecimenSearchDetails.Rows)
			{
				if ((this._patient != null) && (this._patient.PatientGuid != (Guid)drSpecimenSearchDetails[TABLE.Patient.PatientGuid]))
				{
					continue;
				}
				//List view
				ListViewItem lvItem = new ListViewItem();
				lvItem.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenUid) ? string.Empty : (string) drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenUid];			
				lvItem.SubItems.Add(drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenExpirationDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenExpirationDate]));
				lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drSpecimenSearchDetails[TABLE.Patient.PatientFirstName].ToString(), 
					drSpecimenSearchDetails[TABLE.Patient.PatientMiddleName].ToString(), 
					drSpecimenSearchDetails[TABLE.Patient.PatientLastName].ToString()));
				lvItem.SubItems.Add(drSpecimenSearchDetails[TABLE.Patient.DisplayVistaPatientId].ToString());//drSpecimenSearchDetails[TABLE.Patient.PatientSsn].ToString().Insert(3,"-").Insert(6,"-"));
				lvItem.Tag = drSpecimenSearchDetails;
				//if ((System.Convert.ToDateTime(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenExpirationDate])< BOL.VBECSDateTime.GetDivisionCurrentDateTime()) ||
				//	((bool)drSpecimenSearchDetails[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator]))
				if ((bool)drSpecimenSearchDetails[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator])
				{
					lvItem.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
				}
				this.lvSearchResults.Items.Add(lvItem);
			}
			// Only default selection if one match, else user must choose
			if ( lvSearchResults.Items.Count == 1 )
			{
				lvSearchResults.Items[0].Selected = true;
			}
			else
			{
				lvSearchResults.SelectedItems.Clear();
			}
			//
			if (this.lvSearchResults.Items.Count == 0)
			{
				this.Clear();
				ListViewItem lvItem = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
				this.lvSearchResults.Items.Add(lvItem);
				lvItem.Tag = null;
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);

		}

		/// <summary> 
		/// Filter unacceptable specimens.  
		/// Implements BR_35.21
		/// </summary>
		private void FilterExpiredSpecimen()
		{
			//BR_35.21
			//Set filter criteria and sort column and direction
			string filterCriteria = TABLE.PatientSpecimen.UnacceptableSpecimenIndicator+" = 0";
			string sortValue = TABLE.PatientSpecimen.SpecimenExpirationDate+Common.Utility.DescSortOrderSuffix;

			//Apply filter criteria to the table 
			DataRow[] filteredSpecimenRows = this._dtSpecimenSearchDetails.Select(filterCriteria, sortValue);

			this.lvSearchResults.Items.Clear();

			foreach (DataRow drFilteredSpecimen in filteredSpecimenRows)
			{
				if ((this._patient != null) && (this._patient.PatientGuid != (Guid)drFilteredSpecimen[TABLE.Patient.PatientGuid]))
				{
					continue;
				}
				//List view
				ListViewItem lvItem = new ListViewItem();
				lvItem.Text = drFilteredSpecimen.IsNull(TABLE.PatientSpecimen.SpecimenUid) ? string.Empty : (string) drFilteredSpecimen[TABLE.PatientSpecimen.SpecimenUid];			
				lvItem.SubItems.Add(drFilteredSpecimen.IsNull(TABLE.PatientSpecimen.SpecimenExpirationDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drFilteredSpecimen[TABLE.PatientSpecimen.SpecimenExpirationDate]));
				lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drFilteredSpecimen[TABLE.Patient.PatientFirstName].ToString(), 
					drFilteredSpecimen[TABLE.Patient.PatientMiddleName].ToString(), 
					drFilteredSpecimen[TABLE.Patient.PatientLastName].ToString()));
				lvItem.SubItems.Add(drFilteredSpecimen[TABLE.Patient.DisplayVistaPatientId].ToString()); //drFilteredSpecimen[TABLE.Patient.PatientSsn].ToString().Insert(3,"-").Insert(6,"-"));
				lvItem.Tag = drFilteredSpecimen;
				this.lvSearchResults.Items.Add(lvItem);
			}
			// Only default selection if one match, else user must choose
			if ( lvSearchResults.Items.Count == 1 )
			{
				lvSearchResults.Items[0].Selected = true;
			}
			else
			{
				lvSearchResults.SelectedItems.Clear();
			}
			//
			if (this.lvSearchResults.Items.Count == 0)
			{
				this.Clear();
				ListViewItem lvItem = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
				this.lvSearchResults.Items.Add(lvItem);
				lvItem.Tag = null;
			}

			controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);
		}
	
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/05/2002</CreationDate>
		///
		/// <summary>
		/// Private method to parse the entered search string to determine if Patinet Name or ssn or last Name 
		/// initial and last 4 digit of SSN.  Name and SSN are returned as out parameters.
		/// Reused code from PatientSelectTool.cs
		/// </summary>
		/// <param name="searchString"></param>
		/// <param name="patientName"></param>
		/// <param name="patientSSN"></param>
		private void ParsePatientSearchString(string searchString, out string patientName, out string patientSSN)
		{
			//Need to parse search string to determine if search is intended
			//to be on Name, full SSN, Last 5.
			//
			searchString = searchString.ToUpper();
			patientName = string.Empty;
			patientSSN = string.Empty;

			//Check for Last 5
			if (_lastfiveEx.IsMatch(searchString))
			{
				patientName = searchString.Substring(0,1);
				patientSSN = searchString.Substring(1,4);
				return;
			}
			//Check for SSN
			if (_ssnEx.IsMatch(searchString))
			{
				patientSSN = searchString;
				return;
			}
			//Check for Name
			if (_nameEx.IsMatch(searchString))
			{
				patientName = searchString;
				return;
			}
		}

		private void SetComponentProperties()
		{
			this.btnSearch.Text = "&Search";
			this.btnSearch.EnabledButton = false;
			//
			try
			{
				this.dtpExpiresAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
				this.dtpExpiresAfter.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
				this.dtpExpiresAfter.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date;
			}
			catch
			{
				//This fails at design time...
			}
		}
		
		/// <summary>
		/// Sets a tooltip on ABORh textbox
		/// </summary>
		/// <param name="aboRHText"></param>
		public void SetAboRHToolTip(string aboRHText)
		{
			this.toolTip1.SetToolTip(this.txtABORh,aboRHText);
		}

		/// <summary>
		/// Item Selected
		/// </summary>
		protected virtual void OnItemSelected()
		{
			//
			this._specimen = new BOL.Specimen(this._patientSpecimenGUID);
			//
			if ((this._specimen != null) && (this._specimen.Patient != null))
			{
				this.patientInfoToolbar1.Patient = this._specimen.Patient;
			}
			//
			if(ItemSelected != null)
				ItemSelected(true, EventArgs.Empty);
		}

		/// <summary>
		/// Item Deselected
		/// </summary>
		protected virtual void OnItemDeselected()
		{
			//
			this._specimen = null;
			//
			if(ItemDeselected != null)
				ItemDeselected(false, EventArgs.Empty);
		}

		#endregion


		#region Control Events

		/// <summary>
		/// Patient Specimen Search
		/// Implements BR_35.22
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			string patientName = string.Empty;
			string patientSSN = string.Empty;

			using (new WaitCursor())
			{
				try
				{
					this.ParsePatientSearchString(this.txtSearchNameSSN.Text,out patientName,out patientSSN);

					_dtSpecimenSearchDetails = BOL.Specimen.GetSpecimenList(this.txtSearchOrderNumber.Text.ToUpper().Trim(), 
						patientSSN, patientName, dtpExpiresAfter.Value);
					if(this._acceptableOnlySpecimen == true)
					{
						this.FilterExpiredSpecimen();
					}
					else
					{
						PopulateForm();
					}
				}
				catch (BOL.NoRecordsFoundException)
				{
					this.Clear();
					ListViewItem lvi = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
					this.lvSearchResults.Items.Add(lvi);
					controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);
				}
			}

		}

		private void lvSearchResults_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				using (new WaitCursor())
				{
					if (lvSearchResults.SelectedItems.Count > 0 && lvSearchResults.SelectedItems[0].Tag != null)
					{
						//Get selected specimen/patient/order details 
						ListViewItem lvItem = lvSearchResults.SelectedItems[0];
						DataRow drSpecimenSearchDetails = (DataRow) lvItem.Tag;
						BOL.Patient patient = new BOL.Patient(drSpecimenSearchDetails);
				
						//Specimen
						this.txtSpecimenNumber.Text = lvItem.SubItems[0].Text;
						this.txtExpirationDate.Text = lvItem.SubItems[1].Text;
						this.txtPhlebotomist.Text = drSpecimenSearchDetails.IsNull(ARTIFICIAL.Phlebotomist) ? string.Empty : drSpecimenSearchDetails[ARTIFICIAL.Phlebotomist].ToString();
						this.txtCollectionDate.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenCollectionDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenCollectionDate]);
						this.txtReceivedDate.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenReceivedDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenReceivedDate]);
						if ((bool)drSpecimenSearchDetails[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator])
						{
							this.txtVisualInspection.Text = "Unacceptable";
							//
							//DataTable dtComments = BOL.SpecimenComment.GetSpecimenComments((Guid)drSpecimenSearchDetails[TABLE.PatientSpecimen.PatientSpecimenGuid]);
							//if (dtComments.Rows.Count>0)
							//{
							//	this.txtComment.Text = BOL.CannedComment.CombinedComment((Guid)dtComments.Rows[0][TABLE.PatientSpecimenComment.CannedCommentGuid],dtComments.Rows[0][TABLE.PatientSpecimenComment.PatientSpecimenCommentText].ToString());
							//}
							//else
							//{
							//	this.txtComment.Text = string.Empty;
							//}
							if (!drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.CannedCommentGuid))
							{
								this.txtComment.Text = BOL.CannedComment.CombinedComment((Guid)drSpecimenSearchDetails[TABLE.PatientSpecimen.CannedCommentGuid],drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenComments].ToString());
							}
							else
							{
								this.txtComment.Text = drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenComments].ToString();
							}
						}
						else
						{
							this.txtVisualInspection.Text = "Acceptable";
							this.txtComment.Text = string.Empty;
						}

						//Patient
						this.txtPatientName.Text = lvItem.SubItems[2].Text;
						this.txtSSN.Text = lvItem.SubItems[3].Text;
						char sex = drSpecimenSearchDetails.IsNull(TABLE.Patient.PatientSexCode) ? char.MinValue : Convert.ToChar(drSpecimenSearchDetails[TABLE.Patient.PatientSexCode]);
						this.txtSex.Text = Common.Utility.GetSexEnumFromSexChar(sex).ToString();
						this.txtDOB.Text = drSpecimenSearchDetails.IsNull(TABLE.Patient.PatientDob) ? string.Empty : Common.VBECSDateTime.FormatDateString(drSpecimenSearchDetails[TABLE.Patient.PatientDob]);
					
						this.txtABORh.Text = patient.AboRh.AboRHText;
						this.picJustified.Visible = (patient.JustifiedAboRH);
					
						//Set PatientSpecimenGuid (property)
						this._patientSpecimenGUID = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.PatientSpecimenGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[TABLE.PatientSpecimen.PatientSpecimenGuid];
					
						this.OnItemSelected();
					
						//Set tooltip on ABORh 
						if (this.txtABORh.Text.ToString() != String.Empty)
						{
							this.toolTip1.SetToolTip(this.txtABORh,this._specimen.Patient.GetPatientHistoricABORhForTooltip());
						}
					}
					else
					{
						this.OnItemDeselected();
					}
				}
			}
			catch (Exception err)
			{
				MessageBox.Show(err.Message,"VBECS - Error",MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
			}
		}

		private void SearchCriteriaChanged(object sender, System.EventArgs e)
		{
			if (this._nameEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this._lastfiveEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this._ssnEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this.txtSearchOrderNumber.Text != String.Empty)
			{
				this.btnSearch.EnabledButton = true;
			}
			else
			{
				this.btnSearch.EnabledButton = false;
			}
		}

		private void btnSearch_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnSearch.EnabledButton == false)
			{
				this.toolTip1.SetToolTip(this.btnSearch, Common.StrRes.Tooltips.Common.PatientSpecimenSearch().ResString);
			}

		}

		private void lvSearchResults_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.OnUserActivity();

			if (e.Column == 1)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void cbShowUnacceptable_CheckedChanged(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			this._acceptableOnlySpecimen = !this.cbShowUnacceptable.Checked;
			//
			if (btnSearch.EnabledButton)
			{
				this.btnSearch_Click(sender,e);
			}
		}

		private void txtSearchNameSSN_Leave(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this.txtSearchNameSSN.Barcode)
			{
				string[] pieces = this.txtSearchNameSSN.Text.Split(',');
				//
				if (pieces.Length>0)
				{
					this.txtSearchNameSSN.Text = pieces[0].Replace("-",string.Empty);
					if (_ssnEx.IsMatch(this.txtSearchNameSSN.Text))
					{
						btnSearch.EnabledButton = true;
					}
					else
					{
						this.txtSearchNameSSN.Barcode = false;
					}
				}
				else
				{
					this.txtSearchNameSSN.Text = string.Empty;
					this.txtSearchNameSSN.Barcode = false;
				}
			}
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void Speak(object sender, System.EventArgs e)
		{
			string textToSpeak = "";
			
			this.btnSearch_MouseHover(this, EventArgs.Empty);
			textToSpeak = this.toolTip1.GetToolTip(this.btnSearch);
			if (picJustified.Visible)
				textToSpeak = String.Concat(textToSpeak, "The patient has a history of  justified ABO/Rh change");
			Common.Utility.Speak( textToSpeak );		
		}
	}
}
